%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%   Circulation of E-vector along a contour of complex shape


clear all;
close all;
EPS0 = 8.8542*10^(-12);

Q = input('Enter the charge in coulombs for point charge: ');
R1 = input('Enter the lenght in meters of the first radius, a: ');
R2 = input('Enter the lenght in meters of the second radius, b: ');
PHI = input('Enter the angle in radians of the structure: ');

% arcs
Nphi = 1000; 
deltaphi = PHI/Nphi;
% lines
Nl = 1000;
l = (R2-R1);
deltal = l/Nl;

% unit vectors
ur = [1,0];
uphi = [0,1];

for i = 1:2*(Nphi + Nl)
    if i <= Nphi  % inner arc
    r(i) = R1;
    phi(i) = -PHI/2 + deltaphi/2 + (i-1)*deltaphi;
    elseif i <= (Nphi + Nl) %upper line
    r(i) = R1 + deltal/2 + (i-Nphi-1)*deltal;
    phi(i) = PHI/2;
    elseif i <= (2*Nphi + Nl) %outer arc
    r(i) = R2;
    phi(i) = PHI/2 - deltaphi/2 - (i-Nphi-Nl-1)*deltaphi;
    elseif i <= 2*(Nphi + Nl)  %lower line
    r(i) = R2 - deltal/2 - (i-2*Nphi-Nl-1)*deltal;
    phi(i) = -PHI/2;
    end
    
    E(:,i) = Q/r(i)^2/(4*pi*EPS0)*ur;  % Electric field vector
end

% Integration
Int = 0;  
dr = deltal*ur; 
dphi = deltaphi*uphi;

for i = 1:Nphi
    Int = Int + dot(E(:,i),R1*dphi);
end
for i = (Nphi+1):(Nphi+Nl)
    Int = Int + dot(E(:,i),dr);
end
for i = (Nphi+Nl+1):(2*Nphi+Nl)
    Int = Int + dot(E(:,i),-R2*dphi);
end

for i = (2*Nphi+Nl+1):2*(Nphi + Nl)
    Int = Int + dot(E(:,i),-dr);
end
fprintf('Result of integration is %f V.\n',Int)




